<div class="entry-content single-page">
    <h2 id="project-description"><?php _e('Description', 'erua'); ?></h2>

    <?php the_content(); ?>

    <?php
    global $website_url, $status, $project_results, $funding_source, $project_initiative, $students, $universities, $regions, $stakeholders, $team, $activities, $topics, $coordinator, $contact_person, $keywords, $science_fields;

    if ( $website_url ) {
        echo '<h2 id="project-url">' .__('Webpage', 'erua') . '</h2>';
        echo '<p><a id="project-website" href="' . $website_url . '" target="_blank" rel="nofollow">' . $website_url . '</a></p>';
    }

    if ( $status ) {
        echo '<h2 id="project-status">' .__('Status', 'erua') . '</h2>';
        echo '<span class="project-status ' . $status[0]->slug . '">' . $status[0]->name . '</span>';

        if ( $start_date = get_field('eruahaus_project_date_start', get_the_ID()) ) {
            echo '<p>';
            echo date("M-d, Y", strtotime($start_date));
            if ( $end_date = get_field('eruahaus_project_date_end', get_the_ID()) ) {
                echo ' to ' . $end_date;
            }
            echo '</p>';
        }

        if ( $project_results ) {
            echo '<h2 id="project-results">' .__('Results', 'erua') . '</h2>';
            echo '<p>' . $project_results . '</p>';
        }
    }

    if ( $funding_source ) {
        echo '<h2 id="project-funding">' .__('Funding Source', 'erua') . '</h2>';
        echo '<p>' . $funding_source[0]->name . '</p>';        
    }

    if ( $project_initiative ) {
        echo '<h2 id="project-initiative">' .__('ERUA Initiative', 'erua') . '</h2>';
        echo '<p>' . $project_initiative . '</p>';
    }

    if ( $students ) {
        echo '<h2 id="project-students">' .__('ERUA Students', 'erua') . '</h2>';
        echo '<p>' . $students . '</p>';
    }

    if ( $universities ) {
        global $eruahaus_erua_university_taxonomy;
        echo '<universities id="project-universities" style="display: block; margin-bottom: 20px;">';
        echo '<h2>' .__('ERUA University/ies', 'erua') . '</h2>';
        if ( is_array($universities) ) {
            foreach ( $universities as $key => $university ) {
                $separator = ( $key === array_key_last($universities) ) ? '' : ', ';
        
                echo '<span class="project-university"><a href="' . site_url('/') . $eruahaus_erua_university_taxonomy->rewrite['slug'] . '/' . $university->slug . '">'. $university->name .'</a>' . $separator . '</span>';
            }
        }
        echo '</universities>';
    }

    if ( $regions ) {
        echo '<h2 id="project-regions">' .__('ERUA Region/s', 'erua') . '</h2>';
        echo '<p>' . $regions . '</p>';
    }

    if ( $stakeholders ) {
        echo '<h2 id="project-stakeholders">' .__('ERUA Stakeholders', 'erua') . '</h2>';
        echo '<p>' . $stakeholders . '</p>';
    }

    if ( $team ) {
        echo '<h2 id="project-team">' .__('Team', 'erua') . '</h2>';
        echo '<p>' . $team . '</p>';
    }

    if ( $activities ) {
        echo '<h2 id="project-activities">' .__('Activities', 'erua') . '</h2>';
        echo '<p>' . $activities . '</p>';
    }

    if ( $topics ) {
        echo '<h2 id="project-topics">' .__('Topics', 'erua') . '</h2>';
        echo '<p>' . $topics . '</p>';
    }

    if ( $coordinator ) {
        echo '<h2 id="project-coordinator">' .__('Coordinator', 'erua') . '</h2>';
        echo '<p>' . $coordinator . '</p>';
    }

    if ( $contact_person ) {
        echo '<h2 id="project-contact-person">' .__('Contact person', 'erua') . '</h2>';
        echo '<p>' . $contact_person . '</p>';
    }

    if ( $keywords ) {
        global $eruahaus_project_keyword_tags;
        echo '<keywords id="project-keywords" style="display: block; margin-bottom: 20px;">';
        echo '<h2>' .__('Keywords', 'erua') . '</h2>';
        if ( is_array($keywords) ) {
            foreach ( $keywords as $key => $keyword ) {
                $separator = ( $key === array_key_last($keywords) ) ? '' : ', ';
    
                echo '<span class="project-keyword project-tag"><a href="' . site_url('/') . $eruahaus_project_keyword_tags->rewrite['slug'] . '/' . $keyword->slug . '">'. $keyword->name .'</a>' . $separator . '</span>';
            }
        }
        echo '</keywords>';
    }

    if ( $science_fields ) {
        global $eruahaus_science_field_tags;
        echo '<science-fields id="project-science-fields" style="display: block; margin-bottom: 20px;">';
        echo '<h2>' .__('Fields of science', 'erua') . '</h2>';
        if ( is_array($science_fields) ) {
            foreach ( $science_fields as $key => $sf ) {
                $separator = ( $key === array_key_last($science_fields) ) ? '' : ', ';
    
                echo '<span class="project-science-field project-tag"><a href="' . site_url('/') . $eruahaus_science_field_tags->rewrite['slug'] . '/' . $sf->slug . '">'. $sf->name .'</a>' . $separator . '</span>';
            }
        }
        echo '</science-fields>';
    }
    ?>

    <?php
    wp_link_pages();
    ?>

    <?php if ( get_theme_mod( 'blog_share', 1 ) ) {
        // SHARE ICONS
        echo '<div class="blog-share text-center">';
        echo '<div class="is-divider medium"></div>';
        echo do_shortcode( '[share]' );
        echo '</div>';
    } ?>
</div>

<?php if ( get_theme_mod( 'blog_single_footer_meta', 1 ) ) : ?>
    <footer class="entry-meta text-<?php echo get_theme_mod( 'blog_posts_title_align', 'center' ); ?>">
        <?php
        /* translators: used between list items, there is a space after the comma */
        $category_list = get_the_category_list( __( ', ', 'flatsome' ) );

        /* translators: used between list items, there is a space after the comma */
        $tag_list = get_the_tag_list( '', __( ', ', 'flatsome' ) );


        // But this blog has loads of categories so we should probably display them here.
        if ( '' != $tag_list ) {
            $meta_text = __( 'This entry was posted in %1$s and tagged %2$s.', 'flatsome' );
        } else {
            $meta_text = __( 'This entry was posted in %1$s. Bookmark the <a href="%3$s" title="Permalink to %4$s" rel="bookmark">permalink</a>.', 'flatsome' );
        }

        printf( $meta_text, $category_list, $tag_list, get_permalink(), the_title_attribute( 'echo=0' ) );
        ?>
    </footer>
<?php endif; ?>

<?php if ( get_theme_mod( 'blog_author_box', 1 ) ) : ?>
    <div class="entry-author author-box">
        <div class="flex-row align-top">
            <div class="flex-col mr circle">
                <div class="blog-author-image">
                    <?php echo get_avatar( get_the_author_meta( 'ID' ), apply_filters( 'flatsome_author_bio_avatar_size', 90 ) ); ?>
                </div>
            </div>
            <div class="flex-col flex-grow">
                <h5 class="author-name uppercase pt-half">
                    <?php the_author_meta( 'display_name' ); ?>
                </h5>
                <p class="author-desc small"><?php the_author_meta( 'description' ); ?></p>
            </div>
        </div>
    </div>
<?php endif; ?>

<?php if ( get_theme_mod( 'blog_single_next_prev_nav', 1 ) ) :
    flatsome_content_nav( 'nav-below' );
endif; ?>
