<?php
/**
 * Block Name: Hackathon Venue
 *
 * This is the template that displays the Hackathon Venue block.
 */

// create id attribute for specific styling
$id = 'hackathon-venue-' . $block['id'];

// create align class ("alignwide") from block setting ("wide")
$align_class = $block['align'] ? 'align' . $block['align'] : '';

// $classes = ['block-venue'];
// if( !empty( $block['className'] ) )
//     $classes = array_merge( $classes, explode( ' ', $block['className'] ) );

// $anchor = '';
// if( !empty( $block['anchor'] ) )
//     $anchor = ' id="' . sanitize_title( $block['anchor'] ) . '"';

// https://wordpress.stackexchange.com/questions/347021/how-can-i-access-core-paragraph-textcolor-in-a-block-template
$template = array(
    array('core/heading', array(
        'level' => 2,
        'content' => 'Venue',
        'textAlign' => 'center',
    )),
    array( 'core/paragraph', array(
        'content' => "Venue Information.",
    ) )
);

$hackathon_map_location = get_field('hackathon_map_location');
?>
<div id="<?php echo $id; ?>" class="hackathon-venue <?php echo $align_class; ?>">
    <div id="hackathon-venue"><?php echo '<InnerBlocks template="' . esc_attr( wp_json_encode( $template ) ) . '" />'; ?></div>
    <?php if ( $hackathon_map_location && !str_contains($hackathon_map_location, 'data-map-markers="[]"') ) { the_field('hackathon_map_location'); } ?>
</div>
<style type="text/css">
    #<?php echo $id; ?> {
        background: <?php the_field('hackathon_venue_background_color'); ?>;
        color: <?php the_field('hackathon_venue_text_color'); ?>;
    }
</style>