<?php
/**
 * Block Name: Hackathon Results
 *
 * This is the template that displays the Hackathon Results block.
 */

// create id attribute for specific styling
$id = 'hackathon-results-' . $block['id'];

// create align class ("alignwide") from block setting ("wide")
$align_class = $block['align'] ? 'align' . $block['align'] : '';

// $classes = ['block-results'];
// if( !empty( $block['className'] ) )
//     $classes = array_merge( $classes, explode( ' ', $block['className'] ) );

// $anchor = '';
// if( !empty( $block['anchor'] ) )
//     $anchor = ' id="' . sanitize_title( $block['anchor'] ) . '"';

$template = array(
	array('core/heading', array(
		'level' => 2,
		'content' => 'Hackathon Results Go Here',
	)),
    array( 'core/paragraph', array(
        'content' => "Hackathon aftermath. If this Hackathon has finished, write about its results. It will only appear at the front-end when the Hackathon's end date has passed.",
    ) )
);

$datenow = date_create('now', new DateTimeZone('UTC'));
//$datestart = DateTime::createFromFormat('d/m/Y H:i:s', get_field('hackathon_date_start', get_the_ID()));
$dateend = DateTime::createFromFormat('d/m/Y H:i:s', get_field('hackathon_date_end', get_the_ID()));

/**
 * Hide the Block at the Front-End, 
 * if the Hackthon's end date has not yet passed.
 */
if ( is_admin() || ( !is_admin() && $datenow > $dateend ) ) : ?>
<div id="<?php echo $id; ?>" class="hackathon-results <?php echo $align_class; ?>">
    <div id="hackathon-results"><?php echo '<InnerBlocks template="' . esc_attr( wp_json_encode( $template ) ) . '" />'; ?></div>
</div>
<style type="text/css">
    #<?php echo $id; ?> {
        background: <?php the_field('hackathon_results_background_color'); ?>;
        color: <?php the_field('hackathon_results_text_color'); ?>;
    }
</style>
<?php endif; ?>