<?php
/**
 * Block Name: Hackathon About
 *
 * This is the template that displays the Hackathon About block.
 */

// create id attribute for specific styling
$id = 'hackathon-about-' . $block['id'];

// create align class ("alignwide") from block setting ("wide")
$align_class = $block['align'] ? 'align' . $block['align'] : '';

// $classes = ['block-about'];
// if( !empty( $block['className'] ) )
//     $classes = array_merge( $classes, explode( ' ', $block['className'] ) );

// $anchor = '';
// if( !empty( $block['anchor'] ) )
//     $anchor = ' id="' . sanitize_title( $block['anchor'] ) . '"';

$allowed_blocks = array( 'core/heading', 'core/paragraph' );

$template = array(
    array('core/heading', array(
        'level' => 2,
        'content' => 'Heading Goes Here',
    )),
    array( 'core/paragraph', array(
        'content' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.',
    ) )
);

$datenow = date_create('now', new DateTimeZone('UTC'));
//$datestart = DateTime::createFromFormat('d/m/Y H:i:s', get_field('hackathon_date_start', get_the_ID()));
$dateend = DateTime::createFromFormat('d/m/Y H:i:s', get_field('hackathon_date_end', get_the_ID()));

?>
<div id="<?php echo $id; ?>" class="hackathon-about <?php echo $align_class; echo ( $datenow < $dateend ) ? ' top-shadow': '';?>">
<span id="hackathon-about" class="hackathon-about-title"><?php echo ( get_field('hackathon_short_description_title') !== '' ) ? get_field('hackathon_short_description_title') : __('About the Hackathon', 'erua'); ?></span>
<div class="hackathon-short-description-container">
    <div class="hackathon-short-description">
        <?php echo '<InnerBlocks allowedBlocks="' . esc_attr( wp_json_encode( $allowed_blocks ) ) . '" template="' . esc_attr( wp_json_encode( $template ) ) . '" />'; ?>
        <div class="hackathon-about-buttons">
            <?php if ( $agenda_url = get_field('hackathon_agenda_url') ) : ?>
            <div class="hackathon-about-button-container"><a class="hackathon-about-button" target="_blank" rel="nofollow" href="<?php echo $agenda_url; ?>"><?php _e('Agenda', 'erua') ?></a></div>
            <?php endif; ?>
        </div>
    </div>
    <div class="hackathon-banner">
    <?php if ( has_post_thumbnail() ) : ?>
            <div class="entry-image relative">
                <a href="<?php the_permalink();?>" style="display: flex; justify-content: center; margin: 0 auto 20px auto; width: fit-content;">
                    <?php the_post_thumbnail('large'); ?>
                </a>
            </div>
    <?php endif; ?>
    </div>
</div>
</div>
<style type="text/css">
    #<?php echo $id; ?> {
        background: <?php the_field('hackathon_about_background_color'); ?>;
        color: <?php the_field('hackathon_about_text_color'); ?>;
    }
    #<?php echo $id; ?> .hackathon-about-title {
        background: <?php the_field('hackathon_about_title_background_color') ; ?> !important;
        color: <?php the_field('hackathon_about_title_color'); ?> !important;
    }
    #<?php echo $id; ?> .hackathon-about-button-container > .hackathon-about-button {
        background: <?php the_field('hackathon_agenda_background_color') ; ?> !important;
        color: <?php the_field('hackathon_agenda_link_color'); ?> !important;
    }
    #<?php echo $id; ?> .hackathon-about-button-container > .hackathon-about-button:hover {
        background: <?php the_field('hackathon_agenda_background_hover_color') ; ?> !important;
        color: <?php the_field('hackathon_agenda_link_hover_color'); ?> !important;
    }
    <?php if ( is_admin() ) : ?>
    #<?php echo $id; ?> .hackathon-short-description .block-editor-block-list__layout > .wp-block-heading:first-of-type {
        margin-top: 0;
    }
    <?php endif; ?>
</style>