<?php
/**
 * WordPress uses this template for URLs of this form:
 * 
 * http://www.domain.ext/<taxonomy>/<term>
 * 
 * Going up a level to http://www.domain.ext/<taxonomy>/ will cause a 404 error:
 * https://stackoverflow.com/questions/63907037/why-am-i-getting-a-404-error-when-trying-to-reach-the-taxonomy-php-page-without
 */

/**
 * If we are not viewing a specific custom taxonomy,
 * then redirect to the home page.
 */
if ( ! is_tax() ) {
    wp_safe_redirect( home_url() );
    exit;
}

// Aeiforia Projects
$aeiforia_taxonomy_array = [
    'aeiforia-erua-region',
    'aeiforia-erua-stakeholder',
    'aeiforia-erua-university',
    'aeiforia-science-field', # tag
    'aeiforia-funding-source',
    'aeiforia-project-keyword', # tag
    'aeiforia-project-status',
    'aeiforia-sdg',
    'aeiforia-sustainability-pillar'
];

// ERUAHAUS Projects
$eruahaus_taxonomy_array = [
    'eruahaus-erua-university',
    'eruahaus-science-field', # tag
    'eruahaus-project-focus-area',
    'eruahaus-funding-source',
    'eruahaus-project-keyword', # tag
    'eruahaus-project-status',
    'eruahaus-sdg'
];

// ERUAHAUS Creative Blog
$eruahaus_creative_blog_taxonomy_array = [
    'creative-blog-category',
    'creative-blog-tag' # tag
];

// ERUAHAUS ShowRoom
// $eruahaus_showroom_taxonomy_array = [
//     'showroom-category',
//     'showroom-tag' # tag
// ];
// Hackathons # no archives
// Job Opportunities # no archives
// Funding Opportunities # no archives

if ( is_tax( $aeiforia_taxonomy_array ) ) {
    require_once __DIR__ . '/archive-aeiforia-project.php';
}
else if ( is_tax( $eruahaus_taxonomy_array ) ) {
    require_once __DIR__ . '/archive-eruahaus-project.php';
}
else if ( is_tax( $eruahaus_creative_blog_taxonomy_array ) ) {
    require_once __DIR__ . '/archive-creative-blog-post.php';
}
