<?php
get_header();
?>

<?php require_once __DIR__ . '/includes/eruahaus/module-top-section.php'; ?>

<div id="content" class="blog-wrapper blog-single page-wrapper">

    <?php
        do_action('flatsome_before_blog');
    ?>

    <div class="row row-large <?php if(flatsome_option('blog_layout_divider')) echo 'row-divided ';?>">

        <div class="large-12 col">
        <?php
        if( is_single() ) {
            if ( have_posts() ) {

                /* Start the Loop */
                while ( have_posts() ) : the_post();
        ?>
                <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                    <div class="article-inner <?php flatsome_blog_article_classes(); ?>">
                        <header class="entry-header">
                            <div class="entry-header-text entry-header-text-top text-<?php echo get_theme_mod( 'blog_posts_title_align', 'center' ); ?>">
                                <h6 class="entry-category is-xsmall">
                                    <?php echo get_the_category_list( __( ', ', 'flatsome' ) ) ?>
                                </h6>

                                <?php
                                $current_user_id = get_current_user_id();
                                $author_id = (int) get_the_author_meta( 'ID' );
                                $eruahaus_showroom_page_id = ( get_field('eruahaus_showroom_page', 'option') ) ?? null;
                                $eruahaus_showroom_page_url = ( $eruahaus_showroom_page_id ) ? get_permalink($eruahaus_showroom_page_id) : null;

                                $showroom_category = get_the_terms(get_the_ID(), 'showroom-category');
                                $showroom_tags = get_the_terms(get_the_ID(), 'showroom-tag');
                                $showroom_map_locations = get_field('showroom_map_locations');
                                $showroom_gallery_images = get_field('showroom_gallery', get_the_ID());
                                $showroom_video = get_field('showroom_video', get_the_ID());

                                if ( $showroom_category ) {
                                    echo '<h3 id="presentation-category">' . $showroom_category[0]->name . '</h3>';
                                }

                                if ( is_single() ) {
                                    echo '<h1 class="entry-title">' . get_the_title() . '</h1>';
                                } else {
                                    echo '<h2 class="entry-title"><a href="' . get_the_permalink() . '" rel="bookmark" class="plain">' . get_the_title() . '</a></h2>';
                                }

                                if ( $showroom_subtitle = get_field('showroom_subtitle') ) {
                                    echo '<p id="presentation-subtitle" class="text-center">' . $showroom_subtitle . '</p>';
                                }

                                if ( is_single() ) {
                                    if ( current_user_can('administrator') || $current_user_id === $author_id ) echo '<a class="post-edit-link" href="' . get_edit_post_link(get_the_ID()) . '">' . __('(Edit presentation)', 'erua') . '</a>';
                                }
                                ?>

                                <div class="entry-divider is-divider small"></div>

                                <?php
                                $single_showroom_presentation = is_singular( 'showroom' );
                                if ( $single_showroom_presentation && get_theme_mod( 'blog_single_header_meta', 1 ) ) : ?>
                                    <div class="entry-meta uppercase is-xsmall">
                                        <?php flatsome_posted_on(); ?>
                                    </div>
                                <?php elseif ( ! $single_showroom_presentation && 'showroom' == get_post_type() ) : ?>
                                    <div class="entry-meta uppercase is-xsmall">
                                        <?php flatsome_posted_on(); ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <?php if ( has_post_thumbnail() ) : ?>
                                <?php //if ( ! is_single() || ( is_single() && get_theme_mod( 'blog_single_featured_image', 1 ) ) ) : ?>
                                    <div class="entry-image relative">
                                        <?php //get_template_part( 'template-parts/posts/partials/entry-image', 'default' ); ?>
                                        <a href="<?php the_permalink();?>" style="display: flex; justify-content: center; margin-bottom: 20px; ">
                                            <?php the_post_thumbnail('large'); ?>
                                        </a>
                                        <?php //if ( get_theme_mod( 'blog_badge', 1 ) ) get_template_part( 'template-parts/posts/partials/entry', 'post-date' ); ?>
                                    </div>
                                <?php //endif; ?>
                            <?php endif; ?>
                            <?php
                            if ( $showroom_tags ) {

                                echo '<presentation-tags id="presentation-tags" style="display: flex; align-items: baseline; justify-content: end; margin-bottom: 10px;">';
                                echo '<span style="margin-right: 5px;">' .__('Tags:', 'erua') . '</span>';
                                if ( is_array($showroom_tags) ) {
                                    foreach ( $showroom_tags as $key => $tag ) {
                                        $separator = ( $key === array_key_last($showroom_tags) ) ? '' : ', ';
    
                                        if ( $eruahaus_showroom_page_url ) {
                                            echo '<span class="presentation-tag"><a href="' . $eruahaus_showroom_page_url . '?showroom_tag=' . $tag->term_id . '">'. $tag->name .'</a>' . $separator . '</span>';
                                        }
                                        else {
                                            echo '<span class="presentation-tag">'. $tag->name . $separator . '</span>';
                                        }
                                    }
                                }
                                echo '</presentation-tags>';
                            }
                            ?>
                        </header>
                        <div>
                            <?php if ( $showroom_category && $showroom_category[0]->term_id === 158 && $showroom_gallery_images ) : ?>

                            <?php
                            // echo '<pre>';
                            // var_dump($showroom_gallery_images);
                            // echo '</pre>';
                            ?>
                            <div class="swiper-outer-container container">
                                <div class="swiper-container media">
                                    <div class="swiper-wrapper">
                                    <?php
                                    foreach ( $showroom_gallery_images as $image ) {
                                        if ( $image['showroom_gallery_image_location'] === 'Local' ) {
                                            echo '<div class="swiper-slide">';
                                            echo '<img width="600" height="400" src="'.$image['showroom_gallery_image']['sizes']['medium'].'" data-src="'.$image['showroom_gallery_image']['sizes']['medium'].'" class="attachment-medium size-medium wp-post-image lazy-load-active" alt="" decoding="async" sizes="(max-width: 600px) 100vw, 600px">';
                                            echo '</div>';
                                        }
                                        else if ( $image['showroom_gallery_image_location'] === 'Remote' ) {
                                            echo '<div class="swiper-slide">';
                                            echo '<img width="600" height="400" src="'.$image['showroom_gallery_image_url'].'" data-src="'.$image['showroom_gallery_image_url'].'" class="attachment-medium size-medium wp-post-image lazy-load-active" alt="" decoding="async" sizes="(max-width: 600px) 100vw, 600px">';
                                            echo '</div>';
                                        }
                                        else {
                                            echo '<div class="swiper-slide">';
                                            echo 'Could not render image.';
                                            echo '</div>';
                                        }
                                    }
                                    ?>
                                    </div>
                                </div>
                                <!-- Pagination -->
                                <div class="swiper-pagination media"></div>
                                <!-- Navigation -->
                                <div class="swiper-button-next swiper-button-white media"></div>
                                <div class="swiper-button-prev swiper-button-white media"></div>
                            </div>
                            <?php endif; ?>

                            <?php if ( $showroom_category && $showroom_category[0]->term_id === 159 && $showroom_video ) : ?>

                                <?php if ( $showroom_video['showroom_video_location'] === 'Remote' ) {

                                    $video_url = $showroom_video['showroom_video_url'];
                                    $video_url_parts = parse_url( $video_url );
                                    $video_domain = $video_url_parts['host'];
                                    $is_supported_video_provider = preg_match('[youtube\.com|youtu\.be|vimeo\.com|dailymotion\.com]', $video_domain);

                                    if ( $is_supported_video_provider ) {
                                        echo '<br />';
                                        echo do_shortcode( "[get_video_embed_block url='{$video_url}']" );
                                    }

                                }
                                else if ( $showroom_video['showroom_video_location'] === 'Local' ) {
                                    $video_file = $showroom_video['showroom_video_file'];
                                    if ( $video_file ) {
                                        echo '<br />';
                                        $video_id = $video_file['ID'];
                                        $video_url = $video_file['url'];
                                        echo do_shortcode( "[get_video_block fileid='{$video_id}' url='{$video_url}']" );                                                
                                    }
                                } ?>

                            <?php endif; ?>
                        </div>
                        <!-- <aside style="padding: 15px; margin-bottom: 30px; border: 1px solid #999;"> -->
                            <?php                            
                            //echo '<div><strong>Year</strong>: ' . get_the_date( 'Y' ) . '</div>';
                            ?>
                        <!-- </aside> -->
                        <?php get_template_part( 'template-parts/single', 'showroom' ); ?>
                    </div>
                </article>
        <?php
                endwhile;
            } else {
                get_template_part( 'no-results', 'index' );
            }
            //comments_template();
        }
        ?>
        </div>
        <!-- <div class="post-sidebar large-3 col">
            <?php //flatsome_sticky_column_open( 'blog_sticky_sidebar' ); ?>
            <div id="secondary" class="widget-area <?php //flatsome_sidebar_classes(); ?>" role="complementary">
                <?php //do_action( 'before_sidebar' ); ?>
                <?php //if ( ! dynamic_sidebar( 'eruahaus-showroom-sidebar' ) ) : ?>
                <?php //endif; // end sidebar widget area ?>
            </div>
            <?php //flatsome_sticky_column_close( 'blog_sticky_sidebar' ); ?>
        </div> -->
    </div>

    <?php
        do_action('flatsome_after_blog');
    ?>

</div>

<?php
get_footer();
