<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

//================================================================================
// Build the Breadcrumb trail.
//================================================================================

$breadcrumbs = [];
$news_events_landing_page_id = ( get_field('news_events_landing_page', 'option') ) ?? null;

// (1) Add the Site's home page to the breadcrumb trail
$breadcrumbs[] = [
    get_site_url(),
    __('Home', 'erua')
];

// (2) Add Module Root
if ( $news_events_landing_page_id ) {
    // Add the Site's home page to the breadcrumb trail
    $breadcrumbs[] = [
        get_permalink($news_events_landing_page_id),
        get_the_title($news_events_landing_page_id)
    ];
}

// (3) Add current view
if ( ! is_tax() && ! is_archive() && ! is_home() && $news_events_landing_page_id !== get_the_ID() ) {
    $breadcrumbs[] = [
        get_permalink(get_the_ID()),
        get_the_title(get_the_ID())
    ];
}
else if ( is_tax() ) {
    global $page_url, $page_title;

    $breadcrumbs[] = [
        $page_url,
        $page_title
    ];
}
else if ( is_archive() ) {
    global $page_url, $page_title;

    $breadcrumbs[] = [
        $page_url,
        $page_title
    ];
}
else if ( is_home() ) {
    $page_url = get_permalink( get_option( 'page_for_posts' ) );
    $page_title = get_the_title( get_option('page_for_posts', true) );

    $breadcrumbs[] = [
        $page_url,
        $page_title
    ];
}

//================================================================================
// Build the Module Title.
//================================================================================

$title = ( ! is_tax() && ! is_archive() && ! is_home() ) ? get_the_title(get_the_ID()) : $page_title;

?>
<section class="module-top section news-events" style="padding-bottom: 0; z-index: 2;">
    <div class="bg section-bg fill bg-fill bg-loaded"></div>
    <div class="section-content relative">
        <div class="row row-full-width">
            <div class="col small-12 large-12" style="padding-bottom: 0;">
                <div class="col-inner">
                    <ol class="breadcrumb">
                        <?php foreach( $breadcrumbs as $breadcrumb ) : ?>
                        <li class="breadcrumb-item"><a href="<?php echo $breadcrumb[0]; ?>"><span><?php echo $breadcrumb[1]; ?></span></a></li>
                        <?php endforeach; ?>
                    </ol>
                    <div class="module-title"><h3 class="module-heading"><?php echo $title; ?></h3></div>
                    <?php echo do_shortcode('[news_events_menu]'); ?>
                </div>
            </div>
        </div>
    </div>
</section>