<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

/**
 * We'll send emails to the following entities, 
 * after a new post has been submitted.
 * 
 * 1) Applicant
 * 
 * We'll notify the applicant (creator of the post) 
 * that his post was submitted successfully.
 * 
 * 2) Administrators
 */
function send_emails_after_post_creation($post_id) {

    global $EMAIL_SIGNATURE_MESSAGE;

    //$post_title = html_entity_decode( get_the_title( $post_id ), ENT_COMPAT, 'UTF-8' );
    $post_title = get_the_title($post_id);
    $author_id = get_post_field( 'post_author', $post_id );
    $applicant_name = get_the_author_meta( 'display_name', $author_id );
    $applicant_email = sanitize_email( get_the_author_meta( 'user_email', $author_id ) );

    $headers = array(
        "MIME-Version: 1.0",
        "Content-Type: text/html; charset=UTF-8"
    );

    $to = $applicant_email;
    $subject = __('Successful Post Submission', 'erua');

    $message = __('Dear', 'erua') . ' ' . $applicant_name . ',';
    $message .= '<br /><br />';
    $message .= __('Your post has been successfully submitted. You can view your post here:', 'erua');
    $message .= '<br />';
    $message .= '<a href="' . get_post_permalink($post_id) . '">' . get_post_permalink($post_id) . '</a>';
    $message .= '<br /><br />';
    $message .= $EMAIL_SIGNATURE_MESSAGE;

    // Send email to the applicant.
    //wp_mail( $to, $subject, $message, $headers );


    $subject = __('New Post Submission', 'erua');

    // Find all users that are administrators
    $administrators_query = new WP_User_Query( array( 'role' => 'administrator' ) );

    // Administrators Loop
    if ( ! empty( $administrators_query->get_results() ) ) {
        foreach ( $administrators_query->get_results() as $administrator ) {

            //$message .= '<a href="' . get_edit_post_link($post_id) . '">' . get_edit_post_link($post_id) . '</a>';

            $message = __('Dear', 'erua') . ' ' . $administrator->display_name . ',';
            $message .= '<br /><br />';
            $message .= __('A new post has been successfully submitted. You can view the post here:', 'erua');
            $message .= '<br />';
            //$message .= '<a href="' . get_post_permalink($post_id) . '">' . get_post_permalink($post_id) . '</a>';
            $message .= '<a href="' . get_admin_url() . 'post.php?post=' . $post_id . '&action=edit">' . get_admin_url() . 'post.php?post=' . $post_id . '&action=edit</a>';
            $message .= '<br /><br />';
            $message .= __('Please log in to the ECOs platform in order to approve and/or edit the post.');
            $message .= '<br /><br />';
            $message .= $EMAIL_SIGNATURE_MESSAGE;

            // We don't want to send an e-mail to the assignee twice!
            //if ( $administrator->ID != $assignee_id ) {
                //$to = $administrator->user_email;
                //$to = ( $admin_email_address && is_email($admin_email_address) ) ? sanitize_email($admin_email_address) : '2sciencegr@gmail.com';

                // Send email to the administrator.
                wp_mail( $administrator->user_email, $subject, $message, $headers );
            //}
        }
    }

}

//================================================================================
// NOTIFICATION UPDATES.
//================================================================================

/**
 * We'll send email to the applicant, 
 * whenever a post's status has been altered to approved.
 */
function send_emails_on_post_approval($post_id) {

    global $EMAIL_SIGNATURE_MESSAGE;

    $post_author_id = get_post_field( 'post_author', $post_id );

    $request_title = get_the_title($post_id);
    $applicant_name = sanitize_text_field( get_the_author_meta( 'display_name', $post_author_id ) );
    $applicant_email = sanitize_email( get_the_author_meta( 'user_email', $post_author_id ) );

    // $request_statuses = get_the_terms( $post_id, 'document-status' );
    // $request_status = null;
    // foreach ( $request_statuses as $status ) {
    //     $request_status = $status->name;
    // }

    $headers = array(
        'MIME-Version: 1.0',
        'Content-Type: text/html; charset=UTF-8'
    );

    $to = $applicant_email;
    $subject = __('Your post has been approved', 'erua');

    $message = __('Dear', 'erua') . ' ' . $applicant_name . ',';
    $message .= '<br /><br />';
    $message = __('Your post has been reviewed and published. You can view your post here:', 'erua');
    $message .= '<br />';
    $message .= '<a href="' . get_post_permalink($post_id) . '">' . get_post_permalink($post_id) . '</a>';
    $message .= '<br /><br />';
    $message .= $EMAIL_SIGNATURE_MESSAGE;

    // Send email to the applicant.
    wp_mail( $to, $subject, $message, $headers );

}
