<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

/**
 * Enqueue scripts that change the project listings data via AJAX.
 */
function erua_enqueue_eruahaus_projects_search_script() {

    global $post;
    //global $wp;

    /**
     * If @ ERUAHAUS Projects page (id #1055)
     */
    if ( $post && 1055 === intval($post->ID) ) {

        // Enqueue the script in the footer!
        wp_enqueue_script('erua-ajax-search-projects', get_stylesheet_directory_uri() . '/assets/js/ajax-search-projects.js', '', '', true);

        global $wp_query;
        $qvars = $wp_query->query;
        //$qvars['testing'] = 'hmm';
        // Push the query vars to the above script
        wp_localize_script('erua-ajax-search-projects', 'ajax_query_data', ['query' => $qvars]);

        $params = [
            '_ajax_url' => admin_url('admin-ajax.php'),
            '_ajax_action' => 'the_eruahaus_projects_search', # load function hooked to: "wp_ajax_*" action hook
            //'_ajax_post_id' => get_the_ID(),
            /**
             * The nonce is generated based on the current time, 
             * the provided string argument, and the current user ID.
             * https://codex.wordpress.org/Function_Reference/wp_create_nonce
             */
            '_ajax_nonce' => wp_create_nonce('eruahaus_project_filtering_nonce'),
        ];
        // Additionally push some necessary variables to the script
        wp_localize_script('erua-ajax-search-projects', 'ajax_object', $params);

    }

}
add_action('wp_enqueue_scripts', 'erua_enqueue_eruahaus_projects_search_script', 100);

//================================================================================
// AJAX ACTIONS.
//================================================================================

/**
 * This function filters project listings via AJAX.
 */
function erua_ajax_search_eruahaus_projects() {

    /*-------------------------------------------------------------------
        SECURITY
    -------------------------------------------------------------------*/

    /**
     * If the nonce is not set or incorrect, then check_ajax_referrer() 
     * will cause the AJAX call to die, protecting your AJAX call from invalid requests.
     * 
     * https://codex.wordpress.org/WordPress_Nonces
     */
    //check_ajax_referer('eruahaus_project_filtering_nonce', 'ajaxnonce');
    if ( ! check_ajax_referer('eruahaus_project_filtering_nonce', 'ajaxnonce') ) {
        wp_send_json_error();
    }

    // Note: Consider implementing some throttling mechanism to limit AJAX requests?
    // https://stackoverflow.com/questions/7082527/jquery-throttling-and-queuing-of-ajax-requests

    /*-------------------------------------------------------------------
        DEBUG FORM DATA
    -------------------------------------------------------------------*/

    // $html = '';
    // ob_start();

    // echo '<pre>';
    // var_dump($_POST['form_data']);
    // echo '</pre>';

    // $html = ob_get_contents();
    // ob_end_clean();

    // $response = [
    //     'html' => $html,
    // ];
    // wp_send_json_success($response);
    // die();

    /*-------------------------------------------------------------------
        GATHER ALL $_POST DATA
    -------------------------------------------------------------------*/

    $ajax_project_focus_area = null;
    $ajax_keyword_search = null;
    $ajax_project_status = null;
    $ajax_project_universities = null;
    $ajax_project_funding_sources = null;
    $ajax_project_sdgs = null;

    if ( isset($_POST['form_data']['field_65514d0d8f245']) ) {
        $ajax_project_focus_area = filter_var_array($_POST['form_data']['field_65514d0d8f245'], FILTER_VALIDATE_INT);
    }
    if ( isset($_POST['form_data']['field_65514d0a8f244']) ) {
        $ajax_keyword_search = ( strlen($_POST['form_data']['field_65514d0a8f244'][0]) >=3 ) ? $_POST['form_data']['field_65514d0a8f244'][0] : null;
    }
    if ( isset($_POST['form_data']['field_65514d158f247']) ) {
        $ajax_project_status = filter_var_array($_POST['form_data']['field_65514d158f247'], FILTER_VALIDATE_INT);
    }
    if ( isset($_POST['form_data']['field_65514d188f248']) ) {
        $ajax_project_universities = filter_var_array($_POST['form_data']['field_65514d188f248'], FILTER_VALIDATE_INT);
    }
    if ( isset($_POST['form_data']['field_65514d1a8f249']) ) {
        $ajax_project_funding_sources = filter_var_array($_POST['form_data']['field_65514d1a8f249'], FILTER_SANITIZE_FULL_SPECIAL_CHARS);
    }
    if ( isset($_POST['form_data']['field_65514d1e8f24a']) ) {
        $ajax_project_sdgs = filter_var_array($_POST['form_data']['field_65514d1e8f24a'], FILTER_SANITIZE_FULL_SPECIAL_CHARS);
    }

    $ajax_taxonomy = filter_var($_POST['form_data']['_ajax_taxonomy'], FILTER_SANITIZE_FULL_SPECIAL_CHARS);
    $ajax_taxonomy_rewrite_slug = filter_var($_POST['form_data']['_ajax_taxonomy_rewrite_slug'], FILTER_SANITIZE_FULL_SPECIAL_CHARS);
    //$ajax_project_focus_area = filter_var($_POST['form_data']['_ajax_original_term_id'], FILTER_VALIDATE_INT);

    //$query_args = filter_input(INPUT_POST, 'query_args', FILTER_DEFAULT, FILTER_REQUIRE_ARRAY);
    $ajax_original_url = filter_var($_POST['form_data']['_ajax_original_page_url'], FILTER_VALIDATE_URL);
    $ajax_original_term_slug = filter_var($_POST['form_data']['_ajax_original_page_slug'], FILTER_SANITIZE_FULL_SPECIAL_CHARS);
    $ajax_original_term_id = filter_var($_POST['form_data']['_ajax_original_term_id'], FILTER_VALIDATE_INT);

    /*-------------------------------------------------------------------
        PROCESS DATA
    -------------------------------------------------------------------*/

    $project_focus_area_ids = [];
    $project_status_ids = [];
    $project_university_ids = [];
    $project_funding_source_ids = [];
    $project_sdg_ids = [];
    $given_sdg_ids = ( $ajax_project_sdgs ) ? array_map('intval', $ajax_project_sdgs) : [];
    //$all_project_taxonomy_names = get_object_taxonomies( 'eruahaus-project', 'names' );

    // Find all available project focus area terms
    $all_focus_areas = get_terms( [ 'taxonomy' => 'eruahaus-project-focus-area', 'hide_empty' => false ] );

    // Find all available project status terms
    $all_statuses = get_terms( [ 'taxonomy' => 'eruahaus-project-status', 'hide_empty' => false ] );

    // Find all available project university terms
    $all_universities = get_terms( [ 'taxonomy' => 'eruahaus-erua-university', 'hide_empty' => false ] );

    // Find all available project funding sources
    $all_funding_sources = get_terms( [ 'taxonomy' => 'eruahaus-funding-source', 'hide_empty' => false ] );

    // Find all available project SDGs
    $all_sdg = get_terms( [ 'taxonomy' => 'eruahaus-sdg', 'hide_empty' => false ] );

    foreach ( $all_focus_areas as $focus_area ) {
        array_push($project_focus_area_ids, $focus_area->term_id);
    }

    foreach ( $all_statuses as $status ) {
        array_push($project_status_ids, $status->term_id);
    }

    foreach ( $all_universities as $university ) {
        array_push($project_university_ids, $university->term_id);
    }

    foreach ( $all_funding_sources as $fs ) {
        array_push($project_funding_source_ids, $fs->term_id);
    }

    foreach ( $all_sdg as $sdg ) {
        array_push($project_sdg_ids, $sdg->term_id);
    }

    // A provided project category can only be an existing eruahaus-project-focus-area taxonomy
    // if ( !empty($ajax_taxonomy) && !in_array( $ajax_taxonomy, $all_project_taxonomy_names ) ) {
    //     //wp_send_json_error('Taxonomy Error: ' . $ajax_taxonomy);
    //     die();
    // }

    // A provided project focus area can only be an existing eruahaus-project-focus-area taxonomy
    if ( !empty($ajax_project_focus_area) ) {
        foreach( $ajax_project_focus_area as $fa ) {
            if ( !in_array( (int) $fa, $project_focus_area_ids ) ) {
                //wp_send_json_error('Type Error');
                die();
            }
        }
    }

    // A provided project status can only be an existing eruahaus-project-status taxonomy
    if ( !empty($ajax_project_status) ) {
        foreach( $ajax_project_status as $status ) {
            if ( !in_array( (int) $status, $project_status_ids ) ) {
                //wp_send_json_error('Type Error');
                die();
            }
        }
    }

    // A provided project university can only be an existing eruahaus-erua-university taxonomy
    if ( !empty($ajax_project_universities) ) {
        foreach( $ajax_project_universities as $university ) {
            if ( !in_array( (int) $university, $project_university_ids ) ) {
                //wp_send_json_error('Type Error');
                die();
            }
        }
    }

    // A provided project funding source can only be an existing eruahaus-funding-source taxonomy
    if ( !empty($ajax_project_funding_sources) ) {
        foreach( $ajax_project_funding_sources as $fs ) {
            if ( !in_array( (int) $fs, $project_funding_source_ids ) ) {
                //wp_send_json_error('Type Error');
                die();
            }
        }
    }

    // A provided project SDG contribution can only be an existing eruahaus-sdg taxonomy
    if ( !empty($given_sdg_ids) ) {
        foreach( $given_sdg_ids as $sdg ) {
            if ( !in_array( (int) $sdg, $project_sdg_ids ) ) {
                //wp_send_json_error('Type Error');
                die();
            }
        }
    }

    // A provided project funding source can only be an allowed choice
    // if ( !empty($ajax_project_funding_sources) ) {
    //     $valid_choices = array_keys(get_field_object('field_65514d1a8f249')['choices']);
    //     foreach( $ajax_project_funding_sources as $funding_source ) {
    //         if ( !in_array( $funding_source, $valid_choices ) ) {
    //             //wp_send_json_error('Type Error');
    //             die();
    //         }
    //     }
    // }

    //$project_focus_area_filter = ( $ajax_taxonomy !== 'eruahaus-project-focus-area' ) ? $ajax_project_focus_area : $ajax_original_term_id;

    /*-------------------------------------------------------------------
        SET QUERY VARS
    -------------------------------------------------------------------*/

    $filters = [];

    if ( !empty($ajax_project_focus_area) && $ajax_taxonomy !== 'eruahaus-project-focus-area' ) {
        $temp = implode( ',', $ajax_project_focus_area );
        set_query_var( 'project_fa', $temp );
        $filters['project_fa'] = $temp;
    }
    if ( !empty($ajax_project_status && $ajax_taxonomy !== 'eruahaus-project-status' ) ) {
        $temp = implode( ',', $ajax_project_status );
        set_query_var('project_status', $temp );
        $filters['project_status'] = $temp;
    }
    if ( !empty($ajax_project_universities && $ajax_taxonomy !== 'eruahaus-erua-university' ) ) {
        $temp = implode( ',', $ajax_project_universities );
        set_query_var('project_universities', $temp );
        $filters['project_universities'] = $temp;
    }
    if ( !empty($ajax_project_funding_sources) ) {
        $temp = implode( ',', $ajax_project_funding_sources );
        set_query_var('project_fs', $temp );
        $filters['project_fs'] = $temp;
    }
    if ( !empty($given_sdg_ids) ) {
        $temp = implode( ',', $given_sdg_ids );
        set_query_var('project_sdgs', $temp );
        $filters['project_sdgs'] = $temp;
    }
    if ( !empty($ajax_keyword_search) && strlen($ajax_keyword_search) >=3 ) {
        set_query_var('keywords', $ajax_keyword_search);
        $filters['keywords'] = $ajax_keyword_search;
    }
    //set_query_var('paged', 0);

    $query_string = http_build_query($filters);
    $query_string = ( empty($query_string) ) ? '?viewing=all' : '?'.$query_string;

    // If there is an AJAX-provided "viewing" filter, select it.
    //$ajax_filter = (!empty($query_args['viewing' ])) ? $query_args['viewing' ] : 'default';

    /*-------------------------------------------------------------------
        HANDLE PAGINATION
    -------------------------------------------------------------------*/

    /**
     * In order for pagination to work, we need to build again the base URL path.
     * The site_url() gets prepended automatically to the base.
     * 
     * Thus, if our base is "something/mypage/",
     * the base will become "https://mydomain/something/mypage/",
     * and pagination path will be appended to that e.g. "https://mydomain/something/mypage/page/x/"
     * 
     * // https://stackoverflow.com/questions/20150653/wordpress-pagination-not-working-with-ajax
     */
    $path = ( empty($ajax_taxonomy) )
    ? $ajax_original_term_slug . '/'
    : $ajax_taxonomy_rewrite_slug . '/' . $ajax_original_term_slug . '/';

    $base = $path . $query_string;

    $original_req_uri = $_SERVER['REQUEST_URI']; # "/wp-admin/admin-ajax.php"

    /**
     * Overwrite the REQUEST_URI variable on which 
     * pagination ("get_pagenum_link()") depends on in order to build its links
     */
    $_SERVER['REQUEST_URI'] = $base;

    /*-------------------------------------------------------------------
        BUILD NEW QUERY & RENDER THE NEW CONTENT
    -------------------------------------------------------------------*/

    /**
     * The security checks have passed 
     * and the user is allowed to run the specified query.
     * Create a new query!
     */
    $new_query_args = getERUAHAUSQueryArguments($ajax_project_focus_area, $ajax_project_status, $ajax_project_universities, $ajax_project_funding_sources, $ajax_project_sdgs, $ajax_keyword_search);

    // Will reset previous WP Query and clear all query vars!
    wp_reset_query();
    $wp_query = new WP_Query($new_query_args);

    $eruahaus_taxonomies = []; // Cache with transients? https://developer.wordpress.org/apis/transients/
    $eruahaus_taxonomies['eruahaus-project-focus-area'] = get_taxonomy('eruahaus-project-focus-area');
    $eruahaus_taxonomies['eruahaus-project-status'] = get_taxonomy('eruahaus-project-status');
    $eruahaus_taxonomies['eruahaus-erua-university'] = get_taxonomy('eruahaus-erua-university');
    $eruahaus_taxonomies['eruahaus-funding-source'] = get_taxonomy('eruahaus-funding-source');
    $eruahaus_taxonomies['eruahaus-sdg'] = get_taxonomy('eruahaus-sdg');

    $html = '';
    ob_start();

    include_once __DIR__ . '/project-listings-content.php';

    // echo '<pre>';
    // var_dump($new_query_args);
    // echo '</pre>';

    $html = ob_get_contents();
    ob_end_clean();

    // Restore the original REQUEST_URI - in case anything else would resort on it
    $_SERVER['REQUEST_URI'] = $original_req_uri;

    /*-------------------------------------------------------------------
        SEND RESPONSE
    -------------------------------------------------------------------*/
    $response = [
        'html' => $html,
        'query_string' => $query_string,
        'wp_query_args' => $new_query_args,
        'base_url' => $path,
        'results' => $wp_query->post_count
    ];
    wp_send_json_success($response);
    die(); // required. to end AJAX request.
}
// handling ajax action for logged-in users and guests
add_action('wp_ajax_the_eruahaus_projects_search', 'erua_ajax_search_eruahaus_projects');
add_action('wp_ajax_nopriv_the_eruahaus_projects_search', 'erua_ajax_search_eruahaus_projects');
