<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

/**
 * Enqueue scripts that change the project listings data via AJAX.
 */
function erua_enqueue_aeiforia_projects_search_script() {

    //global $post;
    //global $wp;

    /**
     * If @ AEIFORIA page (id #381) or specific project taxonomies.
     */
    //if ( 381 === intval($post->ID) || is_tax( ['aeiforia-project-category', 'aeiforia-sustainability-pillar'] ) ) {
    if ( is_tax( ['aeiforia-project-category'] ) ) {

        // Enqueue the script in the footer!
        wp_enqueue_script('erua-ajax-search-projects', get_stylesheet_directory_uri() . '/assets/js/ajax-search-projects.js', '', '', true);

        global $wp_query;
        $qvars = $wp_query->query;
        //$qvars['testing'] = 'hmm';
        // Push the query vars to the above script
        wp_localize_script('erua-ajax-search-projects', 'ajax_query_data', ['query' => $qvars]);

        $params = [
            '_ajax_url' => admin_url('admin-ajax.php'),
            '_ajax_action' => 'the_aeiforia_projects_search', # load function hooked to: "wp_ajax_*" action hook
            //'_ajax_post_id' => get_the_ID(),
            /**
             * The nonce is generated based on the current time, 
             * the provided string argument, and the current user ID.
             * https://codex.wordpress.org/Function_Reference/wp_create_nonce
             */
            '_ajax_nonce' => wp_create_nonce('aeiforia_project_filtering_nonce'),
        ];
        // Additionally push some necessary variables to the script
        wp_localize_script('erua-ajax-search-projects', 'ajax_object', $params);

    }

}
add_action('wp_enqueue_scripts', 'erua_enqueue_aeiforia_projects_search_script', 100);

//================================================================================
// AJAX ACTIONS.
//================================================================================

/**
 * This function filters project listings via AJAX.
 */
function erua_ajax_search_aeiforia_projects() {

    /*-------------------------------------------------------------------
        SECURITY
    -------------------------------------------------------------------*/

    /**
     * If the nonce is not set or incorrect, then check_ajax_referrer() 
     * will cause the AJAX call to die, protecting your AJAX call from invalid requests.
     * 
     * https://codex.wordpress.org/WordPress_Nonces
     */
    //check_ajax_referer('aeiforia_project_filtering_nonce', 'ajaxnonce');
    if ( ! check_ajax_referer('aeiforia_project_filtering_nonce', 'ajaxnonce') ) {
        wp_send_json_error();
    }

    // Note: Consider implementing some throttling mechanism to limit AJAX requests?
    // https://stackoverflow.com/questions/7082527/jquery-throttling-and-queuing-of-ajax-requests

    /*-------------------------------------------------------------------
        DEBUG FORM DATA
    -------------------------------------------------------------------*/

    // $html = '';
    // ob_start();

    // echo '<pre>';
    // var_dump($_POST['form_data']);
    // echo '</pre>';

    // $html = ob_get_contents();
    // ob_end_clean();

    // $response = [
    //     'html' => $html,
    // ];
    // wp_send_json_success($response);
    // die();

    /*-------------------------------------------------------------------
        GATHER ALL $_POST DATA
    -------------------------------------------------------------------*/

    $ajax_project_category = null;
    $ajax_keyword_search = null;
    $ajax_project_pillars = null;
    $ajax_project_status = null;
    $ajax_project_universities = null;
    $ajax_project_regions = null;
    $ajax_project_stakeholders = null;
    $ajax_project_funding_sources = null;
    $ajax_project_sdgs = null;

    if ( isset($_POST['form_data']['field_65203a2f9321a']) ) {
        $ajax_keyword_search = ( strlen($_POST['form_data']['field_65203a2f9321a'][0]) >=3 ) ? $_POST['form_data']['field_65203a2f9321a'][0] : null;
    }
    if ( isset($_POST['form_data']['field_65203ac070eec']) ) {
        $ajax_project_pillars = filter_var_array($_POST['form_data']['field_65203ac070eec'], FILTER_SANITIZE_FULL_SPECIAL_CHARS);
    }
    if ( isset($_POST['form_data']['field_652040f90c530']) ) {
        $ajax_project_status = filter_var_array($_POST['form_data']['field_652040f90c530'], FILTER_VALIDATE_INT);
    }
    if ( isset($_POST['form_data']['field_6520420c70bae']) ) {
        $ajax_project_universities = filter_var_array($_POST['form_data']['field_6520420c70bae'], FILTER_VALIDATE_INT);
    }
    if ( isset($_POST['form_data']['field_65749bbb0699d']) ) {
        $ajax_project_regions = filter_var_array($_POST['form_data']['field_65749bbb0699d'], FILTER_VALIDATE_INT);
    }
    if ( isset($_POST['form_data']['field_65749bf50699e']) ) {
        $ajax_project_stakeholders = filter_var_array($_POST['form_data']['field_65749bf50699e'], FILTER_VALIDATE_INT);
    }
    if ( isset($_POST['form_data']['field_6520428a9b70f']) ) {
        $ajax_project_funding_sources = filter_var_array($_POST['form_data']['field_6520428a9b70f'], FILTER_SANITIZE_FULL_SPECIAL_CHARS);
    }
    if ( isset($_POST['form_data']['field_652042f35647c']) ) {
        $ajax_project_sdgs = filter_var_array($_POST['form_data']['field_652042f35647c'], FILTER_SANITIZE_FULL_SPECIAL_CHARS);
    }

    $ajax_taxonomy = filter_var($_POST['form_data']['_ajax_taxonomy'], FILTER_SANITIZE_FULL_SPECIAL_CHARS);
    $ajax_taxonomy_rewrite_slug = filter_var($_POST['form_data']['_ajax_taxonomy_rewrite_slug'], FILTER_SANITIZE_FULL_SPECIAL_CHARS);
    $ajax_project_category = filter_var($_POST['form_data']['_ajax_original_term_id'], FILTER_VALIDATE_INT);

    //$query_args = filter_input(INPUT_POST, 'query_args', FILTER_DEFAULT, FILTER_REQUIRE_ARRAY);
    $ajax_original_url = filter_var($_POST['form_data']['_ajax_original_page_url'], FILTER_VALIDATE_URL);
    $ajax_original_term_slug = filter_var($_POST['form_data']['_ajax_original_page_slug'], FILTER_SANITIZE_FULL_SPECIAL_CHARS);
    $ajax_original_term_id = filter_var($_POST['form_data']['_ajax_original_term_id'], FILTER_VALIDATE_INT);
    $ajax_original_term_name = filter_var($_POST['form_data']['_ajax_original_term_name'], FILTER_SANITIZE_FULL_SPECIAL_CHARS);

    /*-------------------------------------------------------------------
        PROCESS DATA
    -------------------------------------------------------------------*/

    $project_category_ids = [];
    $project_pillar_ids = [];
    $project_status_ids = [];
    $project_university_ids = [];
    $project_region_ids = [];
    $project_stakeholder_ids = [];
    $project_funding_source_ids = [];
    $project_sdg_ids = [];
    $given_sdg_ids = ( $ajax_project_sdgs ) ? array_map('intval', $ajax_project_sdgs) : [];
    $all_project_taxonomy_names = get_object_taxonomies( 'aeiforia-project', 'names' );

    // Find all available project category terms
    $all_categories = get_terms( [ 'taxonomy' => 'aeiforia-project-category', 'hide_empty' => false ] );

    // Find all available project sustainability pillar terms
    $all_pillars = get_terms( [ 'taxonomy' => 'aeiforia-sustainability-pillar', 'hide_empty' => false ] );

    // Find all available project status terms
    $all_statuses = get_terms( [ 'taxonomy' => 'aeiforia-project-status', 'hide_empty' => false ] );

    // Find all available project university terms
    $all_universities = get_terms( [ 'taxonomy' => 'aeiforia-erua-university', 'hide_empty' => false ] );

    // Find all available project region terms
    $all_regions = get_terms( [ 'taxonomy' => 'aeiforia-erua-region', 'hide_empty' => false ] );

    // Find all available project stakeholder terms
    $all_stakeholders = get_terms( [ 'taxonomy' => 'aeiforia-erua-stakeholder', 'hide_empty' => false ] );

    // Find all available project funding sources
    $all_funding_sources = get_terms( [ 'taxonomy' => 'aeiforia-funding-source', 'hide_empty' => false ] );

    // Find all available project SDGs
    $all_sdg = get_terms( [ 'taxonomy' => 'aeiforia-sdg', 'hide_empty' => false ] );

    foreach ( $all_categories as $category ) {
        array_push($project_category_ids, $category->term_id);
    }

    foreach ( $all_pillars as $pillar ) {
        array_push($project_pillar_ids, $pillar->term_id);
    }

    foreach ( $all_statuses as $status ) {
        array_push($project_status_ids, $status->term_id);
    }

    foreach ( $all_universities as $university ) {
        array_push($project_university_ids, $university->term_id);
    }

    foreach ( $all_regions as $region ) {
        array_push($project_region_ids, $region->term_id);
    }

    foreach ( $all_stakeholders as $stakeholder ) {
        array_push($project_stakeholder_ids, $stakeholder->term_id);
    }

    foreach ( $all_funding_sources as $fs ) {
        array_push($project_funding_source_ids, $fs->term_id);
    }

    foreach ( $all_sdg as $sdg ) {
        array_push($project_sdg_ids, $sdg->term_id);
    }

    // A provided project category can only be an existing aeiforia-project-category taxonomy
    if ( !empty($ajax_taxonomy) && !in_array( $ajax_taxonomy, $all_project_taxonomy_names ) ) {
        //wp_send_json_error('Taxonomy Error: ' . $ajax_taxonomy);
        die();
    }

    // A provided project pillar can only be an existing aeiforia-sustainability-pillar taxonomy
    if ( !empty($ajax_project_pillars) ) {
        foreach( $ajax_project_pillars as $pillar ) {
            if ( !in_array( (int) $pillar, $project_pillar_ids ) ) {
                //wp_send_json_error('Type Error');
                die();
            }
        }
    }

    // A provided project status can only be an existing aeiforia-project-status taxonomy
    if ( !empty($ajax_project_status) ) {
        foreach( $ajax_project_status as $status ) {
            if ( !in_array( (int) $status, $project_status_ids ) ) {
                //wp_send_json_error('Type Error');
                die();
            }
        }
    }

    // A provided project university can only be an existing aeiforia-erua-university taxonomy
    if ( !empty($ajax_project_universities) ) {
        foreach( $ajax_project_universities as $university ) {
            if ( !in_array( (int) $university, $project_university_ids ) ) {
                //wp_send_json_error('Type Error');
                die();
            }
        }
    }

    // A provided project region can only be an existing aeiforia-erua-region taxonomy
    if ( !empty($ajax_project_regions) ) {
        foreach( $ajax_project_regions as $region ) {
            if ( !in_array( (int) $region, $project_region_ids ) ) {
                //wp_send_json_error('Type Error');
                die();
            }
        }
    }

    // A provided project stakeholder can only be an existing aeiforia-erua-stakeholder taxonomy
    if ( !empty($ajax_project_stakeholders) ) {
        foreach( $ajax_project_stakeholders as $stakeholder ) {
            if ( !in_array( (int) $stakeholder, $project_stakeholder_ids ) ) {
                //wp_send_json_error('Type Error');
                die();
            }
        }
    }

    // A provided project funding source can only be an existing aeiforia-funding-source taxonomy
    if ( !empty($ajax_project_funding_sources) ) {
        foreach( $ajax_project_funding_sources as $fs ) {
            if ( !in_array( (int) $fs, $project_funding_source_ids ) ) {
                //wp_send_json_error('Type Error');
                die();
            }
        }
    }

    // A provided project SDG contribution can only be an existing aeiforia-sdg taxonomy
    if ( !empty($given_sdg_ids) ) {
        foreach( $given_sdg_ids as $sdg ) {
            if ( !in_array( (int) $sdg, $project_sdg_ids ) ) {
                //wp_send_json_error('Type Error');
                die();
            }
        }
    }

    // A provided project funding source can only be an allowed choice
    // if ( !empty($ajax_project_funding_sources) ) {
    //     $valid_choices = array_keys(get_field_object('field_6520428a9b70f')['choices']);
    //     foreach( $ajax_project_funding_sources as $funding_source ) {
    //         if ( !in_array( $funding_source, $valid_choices ) ) {
    //             //wp_send_json_error('Type Error');
    //             die();
    //         }
    //     }
    // }

    //$project_category_filter = ( $ajax_taxonomy !== 'aeiforia-project-category' ) ? $ajax_project_category : $ajax_original_term_id;

    /*-------------------------------------------------------------------
        SET QUERY VARS
    -------------------------------------------------------------------*/

    $filters = [];

    // if ( !empty($ajax_project_category) && $ajax_taxonomy !== 'aeiforia-project-category' ) {
    //     set_query_var('apc', $project_category_filter);
    //     $filters['topicfilter'] = $project_category_filter;
    // }
    if ( !empty($ajax_project_pillars) && $ajax_taxonomy !== 'aeiforia-sustainability-pillar' ) {
        $temp = implode( ',', $ajax_project_pillars );
        set_query_var( 'asp', $temp );
        $filters['asp'] = $temp;
    }
    if ( !empty($ajax_project_status && $ajax_taxonomy !== 'aeiforia-project-status' ) ) {
        $temp = implode( ',', $ajax_project_status );
        set_query_var('project_status', $temp );
        $filters['project_status'] = $temp;
    }
    if ( !empty($ajax_project_universities && $ajax_taxonomy !== 'aeiforia-erua-university' ) ) {
        $temp = implode( ',', $ajax_project_universities );
        set_query_var('project_universities', $temp );
        $filters['project_universities'] = $temp;
    }
    if ( !empty($ajax_project_regions && $ajax_taxonomy !== 'aeiforia-erua-region' ) ) {
        $temp = implode( ',', $ajax_project_regions );
        set_query_var('project_regions', $temp );
        $filters['project_regions'] = $temp;
    }
    if ( !empty($ajax_project_stakeholders && $ajax_taxonomy !== 'aeiforia-erua-stakeholder' ) ) {
        $temp = implode( ',', $ajax_project_stakeholders );
        set_query_var('project_stakeholders', $temp );
        $filters['project_stakeholders'] = $temp;
    }
    if ( !empty($ajax_project_funding_sources) ) {
        $temp = implode( ',', $ajax_project_funding_sources );
        set_query_var('project_fs', $temp );
        $filters['project_fs'] = $temp;
    }
    if ( !empty($given_sdg_ids) ) {
        $temp = implode( ',', $given_sdg_ids );
        set_query_var('project_sdgs', $temp );
        $filters['project_sdgs'] = $temp;
    }
    if ( !empty($ajax_keyword_search) && strlen($ajax_keyword_search) >=3 ) {
        set_query_var('keywords', $ajax_keyword_search);
        $filters['keywords'] = $ajax_keyword_search;
    }
    //set_query_var('paged', 0);

    $query_string = http_build_query($filters);
    $query_string = ( empty($query_string) ) ? '?viewing=all' : '?'.$query_string;

    // If there is an AJAX-provided "viewing" filter, select it.
    //$ajax_filter = (!empty($query_args['viewing' ])) ? $query_args['viewing' ] : 'default';

    /*-------------------------------------------------------------------
        HANDLE PAGINATION
    -------------------------------------------------------------------*/

    /**
     * In order for pagination to work, we need to build again the base URL path.
     * The site_url() gets prepended automatically to the base.
     * 
     * Thus, if our base is "something/mypage/",
     * the base will become "https://mydomain/something/mypage/",
     * and pagination path will be appended to that e.g. "https://mydomain/something/mypage/page/x/"
     * 
     * // https://stackoverflow.com/questions/20150653/wordpress-pagination-not-working-with-ajax
     */
    $path = ( empty($ajax_taxonomy) )
    ? $ajax_original_term_slug . '/'
    : $ajax_taxonomy_rewrite_slug . '/' . $ajax_original_term_slug . '/';

    $base = $path . $query_string;

    $original_req_uri = $_SERVER['REQUEST_URI']; # "/wp-admin/admin-ajax.php"

    /**
     * Overwrite the REQUEST_URI variable on which 
     * pagination ("get_pagenum_link()") depends on in order to build its links
     */
    $_SERVER['REQUEST_URI'] = $base;

    /*-------------------------------------------------------------------
        BUILD NEW QUERY & RENDER THE NEW CONTENT
    -------------------------------------------------------------------*/

    /**
     * The security checks have passed 
     * and the user is allowed to run the specified query.
     * Create a new query!
     */
    $new_query_args = getAeiforiaQueryArguments($ajax_project_category, $ajax_project_pillars, $ajax_project_status, $ajax_project_universities, $ajax_project_regions, $ajax_project_stakeholders, $ajax_project_funding_sources, $ajax_project_sdgs, $ajax_keyword_search);

    // Will reset previous WP Query and clear all query vars!
    wp_reset_query();
    $wp_query = new WP_Query($new_query_args);

    $aeiforia_taxonomies = []; // Cache with transients? https://developer.wordpress.org/apis/transients/
    $aeiforia_taxonomies['aeiforia-project-category'] = get_taxonomy('aeiforia-project-category');
    $aeiforia_taxonomies['aeiforia-sustainability-pillar'] = get_taxonomy('aeiforia-sustainability-pillar');
    $aeiforia_taxonomies['aeiforia-project-status'] = get_taxonomy('aeiforia-project-status');
    $aeiforia_taxonomies['aeiforia-erua-university'] = get_taxonomy('aeiforia-erua-university');
    $aeiforia_taxonomies['aeiforia-erua-region'] = get_taxonomy('aeiforia-erua-region');
    $aeiforia_taxonomies['aeiforia-erua-stakeholder'] = get_taxonomy('aeiforia-erua-stakeholder');
    $aeiforia_taxonomies['aeiforia-funding-source'] = get_taxonomy('aeiforia-funding-source');
    $aeiforia_taxonomies['aeiforia-sdg'] = get_taxonomy('aeiforia-sdg');

    $current_term_name = $ajax_original_term_name;

    $html = '';
    ob_start();

    include_once __DIR__ . '/project-listings-content.php';

    // echo '<pre>';
    // var_dump($new_query_args);
    // echo '</pre>';

    $html = ob_get_contents();
    ob_end_clean();

    // Restore the original REQUEST_URI - in case anything else would resort on it
    $_SERVER['REQUEST_URI'] = $original_req_uri;

    /*-------------------------------------------------------------------
        SEND RESPONSE
    -------------------------------------------------------------------*/
    $response = [
        'html' => $html,
        'query_string' => $query_string,
        'wp_query_args' => $new_query_args,
        'base_url' => $path,
        'results' => $wp_query->post_count
    ];
    wp_send_json_success($response);
    die(); // required. to end AJAX request.
}
// handling ajax action for logged-in users and guests
add_action('wp_ajax_the_aeiforia_projects_search', 'erua_ajax_search_aeiforia_projects');
add_action('wp_ajax_nopriv_the_aeiforia_projects_search', 'erua_ajax_search_aeiforia_projects');
