<?php
/**
 * Header template.
 *
 * @package          Flatsome\Templates
 * @flatsome-version 3.16.0
 */

?>
<!DOCTYPE html>
<html <?php language_attributes(); ?> class="<?php flatsome_html_classes(); ?>">
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>" />
	<link rel="profile" href="http://gmpg.org/xfn/11" />
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

<?php do_action( 'flatsome_after_body_open' ); ?>
<?php wp_body_open(); ?>

<a class="skip-link screen-reader-text" href="#main"><?php esc_html_e( 'Skip to content', 'flatsome' ); ?></a>

<div id="wrapper">

	<?php do_action( 'flatsome_before_header' ); ?>

	<header id="header" class="header <?php flatsome_header_classes(); ?>">
		<div class="header-wrapper">
			<?php get_template_part( 'template-parts/header/header', 'wrapper' ); ?>
		</div>
	</header>

	<?php do_action( 'flatsome_after_header' ); ?>

	<div id="content-wrapper">
		<nav id="sideNav" class="sideNav" data-status="OFF">
			<span id="sideNavCloseButton" class="glyphicon glyphicon-remove"></span>
			<?php
			if ( has_nav_menu( 'side-nav-menu' ) ) {
				wp_nav_menu([
					'theme_location' => 'side-nav-menu',
					'items_wrap' => '<ul id="sideNavMenu" role="menu">' . PHP_EOL . '%3$s' . str_repeat( "\t", 4 ) . '</ul>' . PHP_EOL,
					'container' => false,
					'depth' => 1,
					//'walker' => new Custom_Walker_Nav_Menu
				]);
			}
			?>
			<div class="text-center"><button id="sideNavToggle" type="button"></button></div>
		</nav>
		<?php
		// Get Header Bottom template. Located in flatsome/template-parts/header/header-bottom-*.php
		get_template_part('template-parts/header/header', 'bottom');
		?>
		<main id="main" class="<?php flatsome_main_classes(); ?>">
